<!-- A majority of the work designers do will be on themes in the (Now) Next 1-3 milestone column of their UX Roadmap. These themes are comprised of high-confidence outcomes and validated needs. The UX theme issue is where collaboration should occur, including plans and discussion on subthemes, research, and design feedback. Related issues for design exploration and solution validation should stem from the theme issue. 

One of the advantages of working with UX themes is that it allows us to think and design holistically by designing the theme as a whole as opposed to a single issue at a time trying to piece them together as you go. For more details please refer to this section of the handbook when creating UX Themes: https://about.gitlab.com/handbook/product/ux/product-design/ux-roadmaps/#theme-structure -->

<!-- Theme Issue Title {UX Theme: <theme statement here>} -->
<!-- Theme Statement: A theme is written as a statement that combines the beneficiary, their need, and the expected outcome when the work is delivered. Well-defined statements are concise without sacrificing the substance of the theme so that anyone can understand it at a glance. (For instance; Reduce the effort for security teams to identify and escalate business-critical risks) 

!!Note: The theme statement is the defacto title that will be used to reference the theme and serve as the theme issue title.!! It should be something that is easily understood, that quickly communicates the intent of the theme allowing team members to easily understand and recognize the expected work that will be done.
-->

----

### Problem to solve
<!-- In a brief statement, summerize the problem we are intending to address with this theme. For instance, users are unable to complete [task], or, users struggle with the amount of steps required to complete [task] -->


### Beneficiary 
<!-- Who is the recipient(s) of the value this theme provides; a customer, end-user, or buyer. Who benefits from this theme being executed? This can be a role, a team, or a persona. For instance: "Development teams, [or] Developers, [or], Sasha the Software Engineer". --> 

- **[Direct beneficiary]**

#### Need & Primary JTBD
<!-- What is the JTBD and what are the needs related to the beneficiary and theme? 
- JTBD: The JTBD statement, for instance, (When I am triaging vulns, I want to address business-critical risks, So I can ensure there is no unattended risk in my orgs assets.) 
- Need: Abstracted from the JTBD, for instance, (Identify and escalate business-critical risks detected in my orgs assets.)
--> 

- **JTBD:** 
- **Need:**   

#### Expected outcome
<!-- What will the user be able to achieve when this theme is executed? For instance, (Users will be able to effectively triage vulnerabilities at scale across all their orgs assets.) -->


#### Business objective
<!-- What business objective will result from delivering this theme? This answers why we are working on this theme from a business perspective. Examples of objectives are but are not limited to: Sales rate / conversion rate, Success rate / completion rate, Traffic / visitor count, Engagement, or other business-oriented goals. --> 


#### Confidence
<!-- How well do we understand the user's problem and their need? Refer to https://about.gitlab.com/handbook/product/ux/product-design/ux-roadmaps/#confidence to assess confidence -->


| Confidence | Research | 
| --- | --- | 
| [High/Medium/Low] | [research/insight issue](Link) |

### User-stories
<!-- Product designers should work with their PMs to gather up all of the relevant user stories. Look for alignment with the JTBD added above. Overall, the solution you and your team come up with should help to support the user stories. -->

- [user-story here]
- [user-story here]
- [user-story here]
- [etc.]

### Requirements
<!-- Requirements can be taken from existing features or design issues that were used to build this theme. Any related issues should be linked with this issue in the Feature/solution issues section below. They are more granular validated needs, goals, and additional details that the theme encompasses. These are typically reserved for themes in the next (1-3 milestones) column. Requirements should answer “what” the beneficiary of this theme needs from the solution.

Note: This is not a backlog. If the issue can not be delivered in the theme timeframe then the theme is too big and needs to be broken down into multiple themes. -->

The beneficieray needs to be able to:
- [need here]
- [need here]
- [need here]
- [etc.]

#### Feature/solution issues
<!-- Use this table to track feature issues related to this theme (if applicable). Not all themes require sub-issues as they are typically discovered while working on the theme itself. Think of these issues as if they were the result of breaking down the design into discrete work items. 

Note: if feature issues already exist then you can add them to this table. Keep in mind that these issues will require validation if they are being added to a Theme that's in the Next (1-3 milestones) container and are assumptive.

Refer to https://about.gitlab.com/handbook/product/ux/product-designer/#ux-issue-weights for calculating UX weights.
--> 

| Issue | UX Weight |  
| ---------- | --------- | 
| [Issue](link) | `0 - 10` | 
| [Issue](link) | `0 - 10` | 
| [Issue](link) | `0 - 10` | 

#### Research
<!-- Use this table to track UX research related to this theme. This may include, problem validation and/or solution validation activities. 
--> 

| Issue | Research type | Research status |
| ---------- | --------- | --------- |   
| [Issue]()  | <!--Solution validation, Problem validation, etc., --> |  <!-- Planned, In Progress, Complete, etc.,-->  |  
| [Issue]()  | <!--Solution validation, Problem validation, etc., --> |  <!-- Planned, In Progress, Complete, etc.,-->  |

#### Ready for design checklist
The items are self-check suggestions; they could be contributed by designers, product managers or researchers
* [ ] The stated `Problem to solve` has high confidence (derived from research or other data-gathering techniques)
* [ ] Relevant issues, research, and other background information are linked to the Related issues section
* [ ] The stated `Beneficiary` has been defined
* [ ] There is high confidence in the stated `Need & Primary JTBD` (derived from research or other data gathering techniques)
* [ ] The `Expected outcome` has been defined
* [ ] The `Business objective` has been defined
* [ ] The theme `Confidence` has been defined as High
* [ ] `User-stories` have been defined
* [ ] The `Requirements` have been defined and the scope has been agreed upon
* [ ] This UX Theme contains everyhting necessary to complete a design solution and is ready for design

/label ~"UX"  ~"UX Theme"
